@extends('admin.layout.master')
@section('import-css')
    <link href="{{ asset('assets/admin/css/bootstrap-fileinput.css') }}" rel="stylesheet">
@stop
@section('body')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-white font-weight-bold ">
                    <h2 class="float-left">{{$page_title}}</h2>
                    <a href="{{route('currency.create')}}" class="btn btn-success  btn-icon  float-right"><i class="fa fa-plus"></i> Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>SL</th>
                                <th>Currency Name</th>
                                <th>Buy At</th>
                                <th>Sell At</th>
                                <th>Reserve Amount</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($currencies as $k=>$currency)
                                <tr>
                                    <td>{{ ++$k }}</td>
                                    <td><strong>{{ $currency->name}}</strong></td>
                                    <td><strong>{{ $currency->buy_at}} {{$basic->currency}}</strong></td>
                                    <td><strong>{{ $currency->sell_at}} {{$basic->currency}}</strong></td>
                                    <td><strong>{{ $currency->reserve_amount}} {{$basic->currency}}</strong></td>
                                    <td>
                                        <a href="{{route('currency.edit',$currency)}}" class="btn btn-primary btn-sm btn-icon btn-pill" title="Edit"
                                                data-act="Edit"><i class="fa fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            <tbody>
                        </table>
                    </div>

                    {{$currencies->links()}}
                </div>
            </div>
        </div>
    </div>


@endsection

@section('import-script')
    <script src="{{ asset('assets/admin/js/bootstrap-fileinput.js') }}"></script>
@stop